#version 330
#extension GL_EXT_gpu_shader4 : enable
// kaleidoscope of noise patternsMod01.fsh  by  AI
 
//https://www.shadertoy.com/view/wtdyW2
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float PI = 3.141592658;
const float TWOPI = 2.0 * PI;

// pseudo-random function, returns value between [0.,1.]
float rand (in vec2 st) {
    return fract(sin(dot(st.xy,
                         vec2(31.7667,14.9876)))
                 * 833443.123456);
}

//bilinear value noise function
float bilinearNoise (in vec2 st) {
    vec2 i = floor(st);
    vec2 f = fract(st);

    // Four corners of a 2D square
    float f00 = rand(i);
    float f10 = rand(i + vec2(1.0, 0.0));
    float f01 = rand(i + vec2(0.0, 1.0));
    float f11 = rand(i + vec2(1.0, 1.0));

    vec2 u = smoothstep(0.,1.,(1.-f));
	return u.x*u.y*f00+(1.-u.x)*u.y*f10+
    u.x*(1.-u.y)*f01+(1.-u.x)*(1.-u.y)*f11;
    
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
  vec2 uv =gl_FragCoord.xy/ iResolution.xy;
  //from Cartesian to polar coordinates
  float scale=3.;
  uv=fract(scale*uv)-.5;
  float radius = length(uv);
  float angle = atan(uv.y, uv.x);
  //change Nsections using horizontal movement of mouse
    float Nsections=20.;//-15.*iMouse.x/iResolution.x;
  //create Nsections which are identical
  float angleM = mod(angle, TWOPI/Nsections);
  //make each section symmetric along its bisector
  angleM = abs(angleM -PI/Nsections);
  //back to Cartesian coordinates
  uv = radius*vec2(cos(angleM),sin(angleM));
  uv=sin(uv+.04*iTime);
  vec3 color=vec3(bilinearNoise(100.*uv),bilinearNoise(75.*uv),bilinearNoise(50.*uv));
  gl_FragColor = vec4(color,1.);
}